EnableExplicit

If OpenConsole() = 0
  MessageRequester("OpenConsole() error","Unable to open the console.",0)
  End
EndIf

Define i.l
Global str1$
For i = 1 To 17
  str1$ = str1$ + Chr(205)
Next
ConsoleTitle ("img2z80")
EnableGraphicalConsole(1)
PrintN(Chr(201)+str1$+Chr(187))
PrintN(Chr(186)+" img2z80 - deeph "+Chr(186))
PrintN(Chr(200)+str1$+Chr(188))
PrintN("")

If CountProgramParameters() = 3
  Define output_format.s = ProgramParameter()
  Define output_type.s = ProgramParameter()
  If (output_format = "-asm" Or output_format = "-c") And (output_type = "-h" Or output_type = "-d" Or output_type = "-b")
    Define file.s = ProgramParameter()
    If GetExtensionPart(file) = "jpg" Or GetExtensionPart(file) = "jpeg"
      UseJPEG2000ImageDecoder()
    ElseIf GetExtensionPart(file) = "png"
      UsePNGImageDecoder()
    ElseIf GetExtensionPart(file) = "tif"
      UseTIFFImageDecoder()
    ElseIf GetExtensionPart(file) = "tga"
      UseTGAImageDecoder()
    ElseIf GetExtensionPart(file) <> "bmp"
      PrintN("Error : image format unsupported.")
      Input()
      End
    EndIf
    If LoadImage(0, file)
      If Mod(ImageWidth(0), 8) = 0
        If CreateFile(0, GetPathPart(ProgramFilename())+ReplaceString(GetFilePart(file), GetExtensionPart(file), "h"))
          Define y.l, x.l, x2.l, bin.s
          Select output_format
            Case "-asm"
              WriteStringN(0, "extern char "+ReplaceString(GetFilePart(file), "."+GetExtensionPart(file), "")+"[];")
              WriteStringN(0, "#asm")
              WriteStringN(0, "._"+ReplaceString(GetFilePart(file), "."+GetExtensionPart(file), ""))
              If StartDrawing(ImageOutput(0))
                For y = 0 To ImageHeight(0)-1
                  WriteString(0, Chr(9)+"defb ")
                  For x = 0 To ImageWidth(0)-1 Step 8
                    bin = ""
                    For x2 = 0 To 7
                      If Point(x+x2, y)
                        bin+"0"
                      Else
                        bin+"1"
                      EndIf
                    Next x2
                    Select output_type
                      Case "-h"
                        WriteString(0, "$"+LCase(RSet(Hex(Val("%"+bin)), 2, "0")))
                      Case "-d"
                        WriteString(0, Str(Val("%"+bin)))
                      Case "-b"
                        WriteString(0, "@"+bin)
                    EndSelect
                    If x+x2 <> ImageWidth(0)
                      WriteString(0, ",")
                    EndIf
                  Next x
                  WriteStringN(0, "")
                Next y
                WriteString(0, "#endasm")
                StopDrawing()
              EndIf
            Case "-c"
              WriteStringN(0, "char "+ReplaceString(GetFilePart(file), "."+GetExtensionPart(file), "")+"[]={")
              If StartDrawing(ImageOutput(0))
                For y = 0 To ImageHeight(0)-1
                  WriteString(0, Chr(9))
                  For x = 0 To ImageWidth(0)-1 Step 8
                    bin = ""
                    For x2 = 0 To 7
                      If Point(x+x2, y)
                        bin+"0"
                      Else
                        bin+"1"
                      EndIf
                    Next x2
                    Select output_type
                      Case "-h"
                        WriteString(0, "0x"+LCase(RSet(Hex(Val("%"+bin)), 2, "0")))
                      Case "-d"
                        WriteString(0, Str(Val("%"+bin)))
                      Case "-b"
                        WriteString(0, "0b"+bin)
                    EndSelect
                    If x+x2 <> ImageWidth(0)
                      WriteString(0, ",")
                    EndIf
                  Next x
                  If y <> ImageHeight(0)-1
                    WriteStringN(0, ",")
                  Else
                    WriteStringN(0, "")
                  EndIf
                Next y
                WriteString(0, "};")
                StopDrawing()
              EndIf
          EndSelect
          PrintN(ReplaceString(GetFilePart(file), GetExtensionPart(file), "h")+" correctly generated.")
          CloseFile(0)
        Else
          PrintN("Error : unable to create the output file.")
        EndIf
      Else
        PrintN("Error : the image width is not aligned (8-multiple)")
      EndIf
    Else
      PrintN("Error : unable to open the image.")
    EndIf
  Else
    PrintN("Error : parameters are : <-asm|-c> <-h|-d|-b> <sprite image>")
    PrintN("")
    PrintN("-asm : assembler output format")
    PrintN("-c : C output format")
    PrintN("")
    PrintN("-h : hexadecimal output format")
    PrintN("-d : decimal output format")
    PrintN("-b : binary output format")
    PrintN("")
    PrintN("sprite image : input sprite image (*.jpg|*.jpeg|*.png|*.tif|*.tga|*.bmp)")
  EndIf
Else
  PrintN("Error : parameters are : <-asm|-c> <-h|-d|-b> <sprite image>")
  PrintN("")
  PrintN("-asm : assembler output format")
  PrintN("-c : C output format")
  PrintN("")
  PrintN("-h : hexadecimal output format")
  PrintN("-d : decimal output format")
  PrintN("-b : binary output format")
  PrintN("")
  PrintN("sprite image : input sprite image (*.jpg|*.jpeg|*.png|*.tif|*.tga|*.bmp)")
EndIf
Input()
End
; IDE Options = PureBasic 5.11 (Windows - x86)
; CursorPosition = 60
; FirstLine = 53
; EnableXP
; EnableUser
; Executable = ..\img2z80.exe
; CompileSourceDirectory
; EnablePurifier